#include "PhoneBook.hpp"
#include <iostream>
#include <iomanip>
#include <cstdlib>

PhoneBook::PhoneBook() : _currentIndex(0), _totalContacts(0) {}

PhoneBook::~PhoneBook() {}

std::string PhoneBook::_truncate(const std::string& str) const {
    if (str.length() > 10)
        return str.substr(0, 9) + ".";
    return str;
}

void PhoneBook::_displayContactRow(int index) const {
    std::cout << std::setw(10) << std::right << index << "|";
    std::cout << std::setw(10) << std::right << _truncate(_contacts[index].getFirstName()) << "|";
    std::cout << std::setw(10) << std::right << _truncate(_contacts[index].getLastName()) << "|";
    std::cout << std::setw(10) << std::right << _truncate(_contacts[index].getNickname()) << std::endl;
}

std::string PhoneBook::_getInput(const std::string& prompt) const {
    std::string input;

    while (true) {
        std::cout << prompt;
        if (!std::getline(std::cin, input)) {
            std::cout << std::endl;
            std::exit(0);
        }
        if (!input.empty())
            break;
        std::cout << "Field cannot be empty. Please try again." << std::endl;
    }
    return input;
}

void PhoneBook::addContact() {
    Contact newContact;

    newContact.setFirstName(_getInput("Enter first name: "));
    newContact.setLastName(_getInput("Enter last name: "));
    newContact.setNickname(_getInput("Enter nickname: "));
    newContact.setPhoneNumber(_getInput("Enter phone number: "));
    newContact.setDarkestSecret(_getInput("Enter darkest secret: "));
    newContact.setIsEmpty(false);

    _contacts[_currentIndex] = newContact;
    _currentIndex = (_currentIndex + 1) % 8;
    if (_totalContacts < 8)
        _totalContacts++;

    std::cout << "Contact added successfully!" << std::endl;
}

void PhoneBook::searchContacts() const {
    if (_totalContacts == 0) {
        std::cout << "PhoneBook is empty." << std::endl;
        return;
    }

    std::cout << std::setw(10) << "Index" << "|";
    std::cout << std::setw(10) << "First Name" << "|";
    std::cout << std::setw(10) << "Last Name" << "|";
    std::cout << std::setw(10) << "Nickname" << std::endl;
    std::cout << std::string(44, '-') << std::endl;

    for (int i = 0; i < _totalContacts; i++)
        _displayContactRow(i);

    std::cout << "Enter index to view details: ";
    std::string indexStr;
    if (!std::getline(std::cin, indexStr)) {
        std::cout << std::endl;
        return;
    }

    if (indexStr.length() != 1 || indexStr[0] < '0' || indexStr[0] > '7') {
        std::cout << "Invalid index." << std::endl;
        return;
    }

    int index = indexStr[0] - '0';
    if (index >= _totalContacts) {
        std::cout << "Invalid index." << std::endl;
        return;
    }

    std::cout << "First Name: " << _contacts[index].getFirstName() << std::endl;
    std::cout << "Last Name: " << _contacts[index].getLastName() << std::endl;
    std::cout << "Nickname: " << _contacts[index].getNickname() << std::endl;
    std::cout << "Phone Number: " << _contacts[index].getPhoneNumber() << std::endl;
    std::cout << "Darkest Secret: " << _contacts[index].getDarkestSecret() << std::endl;
}
