#include "Animal.hpp"
#include "Dog.hpp"
#include "Cat.hpp"

int main() {
    std::cout << "=== Array of Animals Test ===" << std::endl;
    std::cout << std::endl;

    const int arraySize = 4;
    Animal* animals[arraySize];

    std::cout << "--- Creating Dogs ---" << std::endl;
    for (int i = 0; i < arraySize / 2; i++) {
        animals[i] = new Dog();
        std::cout << std::endl;
    }

    std::cout << "--- Creating Cats ---" << std::endl;
    for (int i = arraySize / 2; i < arraySize; i++) {
        animals[i] = new Cat();
        std::cout << std::endl;
    }

    std::cout << "=== Testing makeSound ===" << std::endl;
    for (int i = 0; i < arraySize; i++) {
        std::cout << "Animal " << i << " (" << animals[i]->getType() << "): ";
        animals[i]->makeSound();
    }

    std::cout << std::endl;
    std::cout << "=== Deleting Animals (as Animal*) ===" << std::endl;
    for (int i = 0; i < arraySize; i++) {
        delete animals[i];
        std::cout << std::endl;
    }

    std::cout << "========================================" << std::endl;
    std::cout << "=== Deep Copy Test ===" << std::endl;
    std::cout << "========================================" << std::endl;
    std::cout << std::endl;

    Dog originalDog;
    originalDog.getBrain()->setIdea(0, "I want to chase squirrels!");
    originalDog.getBrain()->setIdea(1, "I love my owner!");

    std::cout << std::endl;
    std::cout << "--- Copy constructor test ---" << std::endl;
    Dog copiedDog(originalDog);

    std::cout << std::endl;
    std::cout << "Original Dog's ideas:" << std::endl;
    std::cout << "  Idea 0: " << originalDog.getBrain()->getIdea(0) << std::endl;
    std::cout << "  Idea 1: " << originalDog.getBrain()->getIdea(1) << std::endl;

    std::cout << "Copied Dog's ideas:" << std::endl;
    std::cout << "  Idea 0: " << copiedDog.getBrain()->getIdea(0) << std::endl;
    std::cout << "  Idea 1: " << copiedDog.getBrain()->getIdea(1) << std::endl;

    std::cout << std::endl;
    std::cout << "--- Modifying copied dog's brain ---" << std::endl;
    copiedDog.getBrain()->setIdea(0, "I want to sleep all day!");

    std::cout << "Original Dog's idea 0: " << originalDog.getBrain()->getIdea(0) << std::endl;
    std::cout << "Copied Dog's idea 0: " << copiedDog.getBrain()->getIdea(0) << std::endl;

    std::cout << std::endl;
    std::cout << "--- Verifying deep copy (different addresses) ---" << std::endl;
    std::cout << "Original Brain address: " << originalDog.getBrain() << std::endl;
    std::cout << "Copied Brain address: " << copiedDog.getBrain() << std::endl;

    std::cout << std::endl;
    std::cout << "=== Assignment Operator Test ===" << std::endl;
    Dog assignedDog;
    assignedDog.getBrain()->setIdea(0, "Initial idea");
    std::cout << std::endl;

    std::cout << "Before assignment:" << std::endl;
    std::cout << "  Assigned Dog's idea 0: " << assignedDog.getBrain()->getIdea(0) << std::endl;

    assignedDog = originalDog;

    std::cout << "After assignment:" << std::endl;
    std::cout << "  Assigned Dog's idea 0: " << assignedDog.getBrain()->getIdea(0) << std::endl;
    std::cout << "  Assigned Brain address: " << assignedDog.getBrain() << std::endl;

    std::cout << std::endl;
    std::cout << "=== Cleanup (automatic) ===" << std::endl;

    return 0;
}
