#include "AAnimal.hpp"
#include "Dog.hpp"
#include "Cat.hpp"

int main() {
    std::cout << "=== Abstract Class Test ===" << std::endl;
    std::cout << std::endl;

    std::cout << "--- Creating concrete animals ---" << std::endl;
    const AAnimal* j = new Dog();
    std::cout << std::endl;
    const AAnimal* i = new Cat();
    std::cout << std::endl;

    std::cout << "=== Testing polymorphism ===" << std::endl;
    std::cout << "Type of j: " << j->getType() << std::endl;
    std::cout << "Type of i: " << i->getType() << std::endl;

    std::cout << std::endl;
    std::cout << "=== Sound Tests ===" << std::endl;
    j->makeSound();
    i->makeSound();

    std::cout << std::endl;
    std::cout << "=== Cleanup ===" << std::endl;
    delete j;
    std::cout << std::endl;
    delete i;

    std::cout << std::endl;
    std::cout << "========================================" << std::endl;
    std::cout << "=== Array Test ===" << std::endl;
    std::cout << "========================================" << std::endl;
    std::cout << std::endl;

    const int arraySize = 4;
    AAnimal* animals[arraySize];

    for (int idx = 0; idx < arraySize / 2; idx++) {
        animals[idx] = new Dog();
        std::cout << std::endl;
    }
    for (int idx = arraySize / 2; idx < arraySize; idx++) {
        animals[idx] = new Cat();
        std::cout << std::endl;
    }

    std::cout << "=== Deleting array ===" << std::endl;
    for (int idx = 0; idx < arraySize; idx++) {
        delete animals[idx];
        std::cout << std::endl;
    }

    std::cout << "========================================" << std::endl;
    std::cout << "=== Deep Copy Verification ===" << std::endl;
    std::cout << "========================================" << std::endl;
    std::cout << std::endl;

    Dog original;
    original.getBrain()->setIdea(0, "Original idea");
    std::cout << std::endl;

    Dog copy(original);
    std::cout << std::endl;

    std::cout << "Original brain idea: " << original.getBrain()->getIdea(0) << std::endl;
    std::cout << "Copy brain idea: " << copy.getBrain()->getIdea(0) << std::endl;

    copy.getBrain()->setIdea(0, "Modified idea");
    std::cout << std::endl;
    std::cout << "After modifying copy:" << std::endl;
    std::cout << "Original brain idea: " << original.getBrain()->getIdea(0) << std::endl;
    std::cout << "Copy brain idea: " << copy.getBrain()->getIdea(0) << std::endl;

    std::cout << std::endl;
    std::cout << "=== Automatic cleanup ===" << std::endl;

    return 0;
}
