#include "Bureaucrat.hpp"
#include "AForm.hpp"
#include "ShrubberyCreationForm.hpp"
#include "RobotomyRequestForm.hpp"
#include "PresidentialPardonForm.hpp"
#include "Intern.hpp"
#include <iostream>
#include <cstdlib>
#include <ctime>

int main() {
	std::srand(std::time(NULL));

	Intern someRandomIntern;
	Bureaucrat boss("Boss", 1);

	std::cout << "=== Test 1: Intern creates ShrubberyCreationForm ===" << std::endl;
	{
		AForm* form = someRandomIntern.makeForm("shrubbery creation", "garden");
		if (form) {
			std::cout << *form << std::endl;
			boss.signForm(*form);
			boss.executeForm(*form);
			delete form;
		}
	}

	std::cout << "\n=== Test 2: Intern creates RobotomyRequestForm ===" << std::endl;
	{
		AForm* form = someRandomIntern.makeForm("robotomy request", "Bender");
		if (form) {
			std::cout << *form << std::endl;
			boss.signForm(*form);
			boss.executeForm(*form);
			delete form;
		}
	}

	std::cout << "\n=== Test 3: Intern creates PresidentialPardonForm ===" << std::endl;
	{
		AForm* form = someRandomIntern.makeForm("presidential pardon", "Arthur Dent");
		if (form) {
			std::cout << *form << std::endl;
			boss.signForm(*form);
			boss.executeForm(*form);
			delete form;
		}
	}

	std::cout << "\n=== Test 4: Intern tries to create unknown form ===" << std::endl;
	{
		AForm* form = someRandomIntern.makeForm("coffee request", "everyone");
		if (form) {
			delete form;
		} else {
			std::cout << "Form creation failed (as expected)" << std::endl;
		}
	}

	std::cout << "\n=== Test 5: Full workflow with Intern ===" << std::endl;
	{
		Intern intern;
		Bureaucrat manager("Manager", 20);
		
		AForm* pardon = intern.makeForm("presidential pardon", "Ford Prefect");
		if (pardon) {
			std::cout << *pardon << std::endl;
			manager.signForm(*pardon);
			manager.executeForm(*pardon);
			delete pardon;
		}
	}

	return 0;
}
