#ifndef SCALARCONVERTER_HPP
#define SCALARCONVERTER_HPP

#include <string>
#include <iostream>
#include <cstdlib>
#include <climits>
#include <cfloat>
#include <cmath>
#include <cerrno>

class ScalarConverter
{
private:
	// Private constructor - class is not instantiable
	ScalarConverter();
	ScalarConverter(const ScalarConverter& other);
	ScalarConverter& operator=(const ScalarConverter& other);
	~ScalarConverter();

	// Type detection helpers
	static bool isChar(const std::string& literal);
	static bool isInt(const std::string& literal);
	static bool isFloat(const std::string& literal);
	static bool isDouble(const std::string& literal);
	static bool isPseudoLiteral(const std::string& literal);

	// Conversion helpers
	static void convertFromChar(char c);
	static void convertFromInt(long value);
	static void convertFromFloat(float value);
	static void convertFromDouble(double value);
	static void handlePseudoLiteral(const std::string& literal);

public:
	static void convert(const std::string& literal);
};

#endif
