/* ************************************************************************** */
/*                                                                            */
/*                                                        :::      ::::::::   */
/*   iter.hpp                                           :+:      :+:    :+:   */
/*                                                    +:+ +:+         +:+     */
/*   By: tutor <tutor@student.42.fr>                +#+  +:+       +#+        */
/*                                                +#+#+#+#+#+   +#+           */
/*   Created: 2024/01/01 00:00:00 by tutor             #+#    #+#             */
/*   Updated: 2024/01/01 00:00:00 by tutor            ###   ########.fr       */
/*                                                                            */
/* ************************************************************************** */

#ifndef ITER_HPP
# define ITER_HPP

# include <cstddef>

template<typename T, typename F>
void iter(T* array, std::size_t length, F func)
{
	for (std::size_t i = 0; i < length; i++)
		func(array[i]);
}

template<typename T>
void iter(T* array, std::size_t length, void (*func)(T const&))
{
	for (std::size_t i = 0; i < length; i++)
		func(array[i]);
}

template<typename T>
void iter(T* array, std::size_t length, void (*func)(T&))
{
	for (std::size_t i = 0; i < length; i++)
		func(array[i]);
}

#endif
