/* ************************************************************************** */
/*                                                                            */
/*                                                        :::      ::::::::   */
/*   Array.hpp                                          :+:      :+:    :+:   */
/*                                                    +:+ +:+         +:+     */
/*   By: tutor <tutor@student.42.fr>                +#+  +:+       +#+        */
/*                                                +#+#+#+#+#+   +#+           */
/*   Created: 2024/01/01 00:00:00 by tutor             #+#    #+#             */
/*   Updated: 2024/01/01 00:00:00 by tutor            ###   ########.fr       */
/*                                                                            */
/* ************************************************************************** */

#ifndef ARRAY_HPP
# define ARRAY_HPP

# include <exception>

template<typename T>
class Array
{
private:
	T*				_elements;
	unsigned int	_size;

public:
	Array() : _elements(NULL), _size(0) {}

	Array(unsigned int n) : _elements(new T[n]()), _size(n) {}

	Array(Array const& src) : _elements(NULL), _size(0)
	{
		*this = src;
	}

	~Array()
	{
		delete[] _elements;
	}

	Array& operator=(Array const& rhs)
	{
		if (this != &rhs)
		{
			delete[] _elements;
			_size = rhs._size;
			if (_size > 0)
			{
				_elements = new T[_size];
				for (unsigned int i = 0; i < _size; i++)
					_elements[i] = rhs._elements[i];
			}
			else
				_elements = NULL;
		}
		return *this;
	}

	T& operator[](unsigned int index)
	{
		if (index >= _size)
			throw std::exception();
		return _elements[index];
	}

	T const& operator[](unsigned int index) const
	{
		if (index >= _size)
			throw std::exception();
		return _elements[index];
	}

	unsigned int size() const
	{
		return _size;
	}
};

#endif
