/* ************************************************************************** */
/*                                                                            */
/*                                                        :::      ::::::::   */
/*   main.cpp                                           :+:      :+:    :+:   */
/*                                                    +:+ +:+         +:+     */
/*   By: tutor <tutor@student.42.fr>                +#+  +:+       +#+        */
/*                                                +#+#+#+#+#+   +#+           */
/*   Created: 2024/01/01 00:00:00 by tutor             #+#    #+#             */
/*   Updated: 2024/01/01 00:00:00 by tutor            ###   ########.fr       */
/*                                                                            */
/* ************************************************************************** */

#include <iostream>
#include <string>
#include <cstdlib>
#include "Array.hpp"

#define MAX_VAL 750

int main(void)
{
	std::cout << "=== Test 1: Default constructor (empty array) ===" << std::endl;
	Array<int> emptyArray;
	std::cout << "Empty array size: " << emptyArray.size() << std::endl;

	std::cout << std::endl << "=== Test 2: Parameterized constructor ===" << std::endl;
	Array<int> numbers(5);
	std::cout << "Array size: " << numbers.size() << std::endl;
	std::cout << "Default values: ";
	for (unsigned int i = 0; i < numbers.size(); i++)
		std::cout << numbers[i] << " ";
	std::cout << std::endl;

	std::cout << std::endl << "=== Test 3: Element assignment ===" << std::endl;
	for (unsigned int i = 0; i < numbers.size(); i++)
		numbers[i] = i * 10;
	std::cout << "After assignment: ";
	for (unsigned int i = 0; i < numbers.size(); i++)
		std::cout << numbers[i] << " ";
	std::cout << std::endl;

	std::cout << std::endl << "=== Test 4: Copy constructor (deep copy) ===" << std::endl;
	Array<int> copyArray(numbers);
	std::cout << "Original: ";
	for (unsigned int i = 0; i < numbers.size(); i++)
		std::cout << numbers[i] << " ";
	std::cout << std::endl;
	std::cout << "Copy: ";
	for (unsigned int i = 0; i < copyArray.size(); i++)
		std::cout << copyArray[i] << " ";
	std::cout << std::endl;

	numbers[0] = 999;
	std::cout << "After modifying original[0] to 999:" << std::endl;
	std::cout << "Original[0]: " << numbers[0] << std::endl;
	std::cout << "Copy[0]: " << copyArray[0] << " (unchanged - deep copy works)" << std::endl;

	std::cout << std::endl << "=== Test 5: Assignment operator (deep copy) ===" << std::endl;
	Array<int> assignedArray;
	assignedArray = numbers;
	std::cout << "Assigned array: ";
	for (unsigned int i = 0; i < assignedArray.size(); i++)
		std::cout << assignedArray[i] << " ";
	std::cout << std::endl;

	numbers[1] = 888;
	std::cout << "After modifying original[1] to 888:" << std::endl;
	std::cout << "Original[1]: " << numbers[1] << std::endl;
	std::cout << "Assigned[1]: " << assignedArray[1] << " (unchanged - deep copy works)" << std::endl;

	std::cout << std::endl << "=== Test 6: Out of bounds exception ===" << std::endl;
	try
	{
		std::cout << "Trying to access index 100 on array of size 5..." << std::endl;
		std::cout << numbers[100] << std::endl;
	}
	catch (std::exception& e)
	{
		std::cout << "Exception caught: out of bounds access" << std::endl;
	}

	try
	{
		std::cout << "Trying to access index 0 on empty array..." << std::endl;
		std::cout << emptyArray[0] << std::endl;
	}
	catch (std::exception& e)
	{
		std::cout << "Exception caught: out of bounds access" << std::endl;
	}

	std::cout << std::endl << "=== Test 7: Array with strings ===" << std::endl;
	Array<std::string> strArray(3);
	strArray[0] = "Hello";
	strArray[1] = "World";
	strArray[2] = "42";
	std::cout << "String array: ";
	for (unsigned int i = 0; i < strArray.size(); i++)
		std::cout << strArray[i] << " ";
	std::cout << std::endl;

	std::cout << std::endl << "=== Test 8: Large array test ===" << std::endl;
	Array<int> largeArray(MAX_VAL);
	int* mirror = new int[MAX_VAL];
	std::srand(42);
	for (int i = 0; i < MAX_VAL; i++)
	{
		int value = std::rand();
		largeArray[i] = value;
		mirror[i] = value;
	}
	bool match = true;
	for (int i = 0; i < MAX_VAL; i++)
	{
		if (largeArray[i] != mirror[i])
		{
			match = false;
			break;
		}
	}
	std::cout << "Large array (" << MAX_VAL << " elements) test: " 
			  << (match ? "PASSED" : "FAILED") << std::endl;
	delete[] mirror;

	std::cout << std::endl << "=== Test 9: Const array access ===" << std::endl;
	Array<int> const constArray(numbers);
	std::cout << "Const array[0]: " << constArray[0] << std::endl;
	std::cout << "Const array size: " << constArray.size() << std::endl;

	std::cout << std::endl << "=== All tests completed ===" << std::endl;

	return 0;
}
