/* ************************************************************************** */
/*                                                                            */
/*                                                        :::      ::::::::   */
/*   Span.hpp                                           :+:      :+:    :+:   */
/*                                                    +:+ +:+         +:+     */
/*   By: student <student@42.fr>                    +#+  +:+       +#+        */
/*                                                +#+#+#+#+#+   +#+           */
/*   Created: 2024/01/01 00:00:00 by student           #+#    #+#             */
/*   Updated: 2024/01/01 00:00:00 by student          ###   ########.fr       */
/*                                                                            */
/* ************************************************************************** */

#ifndef SPAN_HPP
# define SPAN_HPP

# include <vector>
# include <exception>
# include <algorithm>
# include <climits>

class Span
{
private:
	unsigned int		_maxSize;
	std::vector<int>	_numbers;

	Span();

public:
	Span(unsigned int n);
	Span(const Span& other);
	Span& operator=(const Span& other);
	~Span();

	void	addNumber(int n);

	template<typename Iterator>
	void	addNumbers(Iterator begin, Iterator end)
	{
		while (begin != end)
		{
			addNumber(*begin);
			++begin;
		}
	}

	unsigned int	shortestSpan() const;
	unsigned int	longestSpan() const;

	class SpanFullException : public std::exception
	{
	public:
		virtual const char* what() const throw()
		{
			return "Span is full, cannot add more numbers";
		}
	};

	class NotEnoughNumbersException : public std::exception
	{
	public:
		virtual const char* what() const throw()
		{
			return "Not enough numbers to calculate span (need at least 2)";
		}
	};
};

#endif
