/* ************************************************************************** */
/*                                                                            */
/*                                                        :::      ::::::::   */
/*   main.cpp                                           :+:      :+:    :+:   */
/*                                                    +:+ +:+         +:+     */
/*   By: student <student@42.fr>                    +#+  +:+       +#+        */
/*                                                +#+#+#+#+#+   +#+           */
/*   Created: 2024/01/01 00:00:00 by student           #+#    #+#             */
/*   Updated: 2024/01/01 00:00:00 by student          ###   ########.fr       */
/*                                                                            */
/* ************************************************************************** */

#include "Span.hpp"
#include <iostream>
#include <cstdlib>
#include <ctime>

int main()
{
	std::cout << "=== Subject Test ===" << std::endl;
	{
		Span sp = Span(5);
		sp.addNumber(6);
		sp.addNumber(3);
		sp.addNumber(17);
		sp.addNumber(9);
		sp.addNumber(11);

		std::cout << sp.shortestSpan() << std::endl;
		std::cout << sp.longestSpan() << std::endl;
	}

	std::cout << std::endl << "=== Test with 10,000 numbers ===" << std::endl;
	{
		Span bigSpan(10000);

		std::srand(static_cast<unsigned int>(std::time(0)));
		for (int i = 0; i < 10000; ++i)
			bigSpan.addNumber(std::rand());

		std::cout << "Shortest span: " << bigSpan.shortestSpan() << std::endl;
		std::cout << "Longest span: " << bigSpan.longestSpan() << std::endl;
	}

	std::cout << std::endl << "=== Test addNumbers with range ===" << std::endl;
	{
		Span sp(10);
		std::vector<int> vec;
		for (int i = 0; i < 10; ++i)
			vec.push_back(i * 10);

		sp.addNumbers(vec.begin(), vec.end());

		std::cout << "Shortest span: " << sp.shortestSpan() << std::endl;
		std::cout << "Longest span: " << sp.longestSpan() << std::endl;
	}

	std::cout << std::endl << "=== Exception Tests ===" << std::endl;
	{
		Span sp(3);
		sp.addNumber(1);
		sp.addNumber(2);
		sp.addNumber(3);

		try
		{
			sp.addNumber(4);
		}
		catch (std::exception& e)
		{
			std::cout << "Exception (full): " << e.what() << std::endl;
		}
	}

	{
		Span sp(5);
		sp.addNumber(42);

		try
		{
			sp.shortestSpan();
		}
		catch (std::exception& e)
		{
			std::cout << "Exception (not enough): " << e.what() << std::endl;
		}
	}

	{
		Span sp(5);

		try
		{
			sp.longestSpan();
		}
		catch (std::exception& e)
		{
			std::cout << "Exception (empty): " << e.what() << std::endl;
		}
	}

	std::cout << std::endl << "=== Test with 100,000 numbers using addNumbers ===" << std::endl;
	{
		Span hugeSpan(100000);
		std::vector<int> numbers;
		numbers.reserve(100000);

		for (int i = 0; i < 100000; ++i)
			numbers.push_back(i);

		hugeSpan.addNumbers(numbers.begin(), numbers.end());

		std::cout << "Shortest span: " << hugeSpan.shortestSpan() << std::endl;
		std::cout << "Longest span: " << hugeSpan.longestSpan() << std::endl;
	}

	return 0;
}
