#include "RPN.hpp"

RPN::RPN() {}

RPN::~RPN() {}

RPN::RPN(const RPN& other) : _stack(other._stack) {}

RPN& RPN::operator=(const RPN& other) {
    if (this != &other) {
        _stack = other._stack;
    }
    return *this;
}

bool RPN::isOperator(char c) const {
    return c == '+' || c == '-' || c == '*' || c == '/';
}

int RPN::performOperation(int a, int b, char op) const {
    switch (op) {
        case '+':
            return a + b;
        case '-':
            return a - b;
        case '*':
            return a * b;
        case '/':
            if (b == 0)
                throw std::runtime_error("Error: division by zero");
            return a / b;
        default:
            throw std::runtime_error("Error: unknown operator");
    }
}

int RPN::evaluate(const std::string& expression) {
    while (!_stack.empty())
        _stack.pop();

    std::istringstream iss(expression);
    std::string token;

    while (iss >> token) {
        if (token.length() == 1 && isOperator(token[0])) {
            if (_stack.size() < 2)
                throw std::runtime_error("Error");
            
            int b = _stack.top();
            _stack.pop();
            int a = _stack.top();
            _stack.pop();
            
            int result = performOperation(a, b, token[0]);
            _stack.push(result);
        }
        else if (token.length() == 1 && std::isdigit(token[0])) {
            _stack.push(token[0] - '0');
        }
        else if (token.length() == 2 && token[0] == '-' && std::isdigit(token[1])) {
            _stack.push(-(token[1] - '0'));
        }
        else {
            bool isNumber = true;
            size_t start = 0;
            if (token[0] == '-' && token.length() > 1)
                start = 1;
            for (size_t i = start; i < token.length(); i++) {
                if (!std::isdigit(token[i])) {
                    isNumber = false;
                    break;
                }
            }
            if (isNumber && token.length() > 1) {
                throw std::runtime_error("Error");
            }
            throw std::runtime_error("Error");
        }
    }

    if (_stack.size() != 1)
        throw std::runtime_error("Error");

    return _stack.top();
}
