#ifndef PMERGEME_HPP
#define PMERGEME_HPP

#include <vector>
#include <deque>
#include <string>
#include <iostream>
#include <sstream>
#include <cstdlib>
#include <ctime>
#include <stdexcept>
#include <algorithm>
#include <utility>
#include <sys/time.h>

class PmergeMe {
private:
    std::vector<int> _vec;
    std::deque<int> _deq;

    PmergeMe(const PmergeMe& other);
    PmergeMe& operator=(const PmergeMe& other);

    // Jacobsthal sequence
    size_t jacobsthal(size_t n) const;
    
    // Vector operations
    void mergeInsertSortVector(std::vector<int>& arr);
    void insertWithBinarySearchVector(std::vector<int>& sorted, int value, size_t maxPos);
    
    // Deque operations
    void mergeInsertSortDeque(std::deque<int>& arr);
    void insertWithBinarySearchDeque(std::deque<int>& sorted, int value, size_t maxPos);

public:
    PmergeMe();
    ~PmergeMe();

    void parseInput(int argc, char** argv);
    void sort();
    void displayBefore() const;
    void displayAfter() const;
    double getVectorTime() const;
    double getDequeTime() const;

private:
    double _vectorTime;
    double _dequeTime;
};

#endif
