#include "PmergeMe.hpp"

int main(int argc, char** argv) {
    if (argc < 2) {
        std::cerr << "Error" << std::endl;
        return 1;
    }

    PmergeMe sorter;
    
    try {
        sorter.parseInput(argc, argv);
        sorter.displayBefore();
        sorter.sort();
        sorter.displayAfter();
        
        std::cout << "Time to process a range of " << (argc - 1) 
                  << " elements with std::vector : " << sorter.getVectorTime() 
                  << " us" << std::endl;
        std::cout << "Time to process a range of " << (argc - 1) 
                  << " elements with std::deque  : " << sorter.getDequeTime() 
                  << " us" << std::endl;
    }
    catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
        return 1;
    }
    
    return 0;
}
